<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}"/>
<head>
  <meta http-equiv="X-UA-Compatible" value="IE=7"> 
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Expires" content="-1">
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
  <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
  <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
  <link type="text/css" rel="stylesheet" href="/styles/eventactions.min.css${version}">
  <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
  <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
  <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
  <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
  <script type="text/javascript" src="/js/common.js${version}"></script>
  <script type="text/javascript" src="/js/eventactions.js${version}"></script>
  <c:forEach var="jssrc" items="${page.scriptSource}">
    <script type="text/javascript" src="${jssrc}${version}"></script>
  </c:forEach>
  <title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf" %>
  <%@ include file="menu.jspf" %>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>
      
      <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">
        <div id="cmdFileExecutionDialog" title="${res.EventActionsCmdFileDialogTitle}" class="hidden">
          <input type="hidden" id="cmdfile_oid" name="cmdfile_oid" value=""/>
          <input type="hidden" id="cmdfile_oid_dashed" name="cmdfile_oid_dashed" value=""/>

          <%-- holds error message warning --%>
          <div class="ui-corner-all" id="errorcontainer">${res.ErrorDialogBoxMsg}</div>
          <br/>
          <br/>

          <div class="label-value-pair">
            <label>${res.EventActionsEvent}</label>
            <div class="value" id="eventName"></div>
          </div>

          <div class="label-value-pair">
            <label for="cmdfile_checkbox">${res.EventActionsCmdFileExecution}</label>
            <div class="value">
              <input type="checkbox"
                id="cmdfile_checkbox"
                name="cmdfile_checkbox"
                class="checkbox ui-corner-all editable"
                value="" />
            </div>
          </div>

          <div id="cmdfile_selectbox" class="label-value-pair">
            <label for="cmdfile_select">${res.EventActionsCmdFileChoose}</label>
            <div class="valueEntry" rel="#cmdFilesDirToolTip">
              <select id="cmdfile_select" 
                name="cmdfile_select" 
                size="1"
                class="dropdown ui-corner-all editable">
                <c:forEach items="${cmdFilesListMap}" var="cmdFile">
                  <option value="${cmdFile.key}">${cmdFile.key}</option>
                </c:forEach>
              </select>
            </div>
          </div>

          <%-- only display duration boxes is supported --%>
          <div id="cmdFileDiv">
            <div class="label-value-pair">
              <label for="cmdfile_durationMin">${res.EventActionsCmdFileDuration}</label>
              <div class="valueEntry">
                <input type="text"
                  id="cmdfile_durationMin"
                  name="cmdfile_durationMin"
                  minlength="0"
                  maxlength="2"
                  min="0" 
                  max="59" 
                  size="2" 
                  class="textinput ui-corner-all mins required editable"
                  rel="#resMinSecsDialogToolTip"
                  value=""/>

                <div class="unit">${res.MinsSecsSpacer}</div>

                <input type="text"
                  id="cmdfile_durationSec"
                  name="cmdfile_durationSec"
                  minlength="0"
                  maxlength="2"
                  min="0" 
                  max="59" 
                  size="2" 
                  class="textinput ui-corner-all secs required editable"
                  rel="#resMinSecsDialogToolTip"
                  value=""/>

                <div class="unit">${res.MinsSecsUnits}</div>
              </div>
            </div>
          </div> <%-- id="cmdFileDiv" --%>
        </div> <%-- End of cmdFileExecution --%>
              
         <%--  Warn the user if event logging is disabled --%>
        <c:if test="${eventLoggingConfigured eq false}">
	       <div class="label-value-pair">
              <div id="eventLoggingConfigure" class="valueEntry">
              <span>
	          <div class="value">${res.EventLoggingDisabled}&nbsp;</div>
	          <div class="value"><a href="${logsettingsurl}">${res.ClickHereToConfigure}</a></div>
	          </span>
	          </div>    
	       </div>
        </c:if>
              
        <h2 class="expandable">${res.SeverityCritical}</h2>
        <div id="criticalTableDiv">
          <table id="criticalTable">
            <%-- Row: Table Heading --%>
            <tr>
              <th><img width="18" height="18" border="0" alt="" src="images/cross.png${version}">&nbsp;&nbsp;${res.EventActionsEvent}</th>
              <th class="headingTh">${res.EventActionsLogging}</th>
              <th class="headingTh">${res.EventActionsEmail}</th>
              <th class="headingTh">${res.EventActionsShutdown}</th>
              <th class="headingTh">${res.EventActionsCommandFile}</th>
            </tr>
                    
            <%-- Row: Table Data --%>
            <c:forEach var="eventAction" items="${eventActionsList}" varStatus="criticalTableRowCnt">
              <c:if test="${eventAction.critical}">
                <tr ${criticalTableRowCnt.index%2 == 0 ? 'class="alt"' : ''}>
                  <%-- Used to create the rows of data --%>
                  <%@ include file="eventactionsrows.jspf" %>
                </tr>
              </c:if>
            </c:forEach>
          </table>
        </div>

        <h2 class="expandable">${res.SeverityWarning}</h2>
        <div id="warningTableDiv">
          <table id="warningTable">
            <%-- Row: Table Heading --%>
            <tr>
              <th><img width="18" height="18" border="0" alt="" src="images/warning.png${version}">&nbsp;&nbsp;${res.EventActionsEvent}</th>
              <th class="headingTh">${res.EventActionsLogging}</th>
              <th class="headingTh">${res.EventActionsEmail}</th>
              <th class="headingTh">${res.EventActionsShutdown}</th>
              <th class="headingTh">${res.EventActionsCommandFile}</th>
            </tr>

            <%-- Row: Table Data --%>
            <c:forEach var="eventAction" items="${eventActionsList}" varStatus="warningTableRowCnt">
              <c:if test="${eventAction.warning}">
                <tr ${warningTableRowCnt.index%2 == 0 ? 'class="alt"' : ''}>
                  <%-- Used to create the rows of data --%>
                  <%@ include file="eventactionsrows.jspf" %>
                </tr>
              </c:if>
            </c:forEach>
          </table>
        </div>

        <h2 class="expandable minimized">${res.SeverityInformational}</h2>
        <div id="informationalTableDiv">
          <table id="informationalTable">
            <%-- Row: Table Heading --%>
            <tr>
              <th><img width="18" height="18" border="0" alt="" src="images/info.png${version}">&nbsp;&nbsp;${res.EventActionsEvent}</th>
              <th class="headingTh">${res.EventActionsLogging}</th>
              <th class="headingTh">${res.EventActionsEmail}</th>
              <th class="headingTh">${res.EventActionsShutdown}</th>
              <th class="headingTh">${res.EventActionsCommandFile}</th>
            </tr>

            <%-- Row: Table Data --%>
            <c:forEach var="eventAction" items="${eventActionsList}" varStatus="informationalTableRowCnt">
              <c:if test="${eventAction.informational}">
                <tr ${informationalTableRowCnt.index%2 == 0 ? 'class="alt"' : ''}>
                  <%-- Used to create the rows of data --%>
                  <%@ include file="eventactionsrows.jspf" %>
                </tr>
              </c:if>
            </c:forEach>
          </table>
        </div>
        
      </div> <%-- mainbox --%>

      <div id="button-bar">
        <input type="submit" value="${res.ButtonApply}" class="button" id="apply" name="apply" disabled="disabled"/>
      </div>

      <%-- cluetip tooltips --%>
      <div id="resMinSecsDialogToolTip">${res.MinsSecsDialogToolTip}</div>
      <div id="cmdFilesDirToolTip">${cmdFilesDirTooltip}</div>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
      <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
    </form>
  </main><%-- End of container --%>

  <div id="res">
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span>
    <span id="resEventLoggingConfigured">${eventLoggingConfigured}</span>
    <span id="resInvalidMinsFormat">${res.MinsError}</span>
    <span id="resInvalidSecsFormat">${res.SecsError}</span>
    <span id="resButtonOK">${res.ButtonOK}</span>
    <span id="resButtonCancel">${res.ButtonCancel}</span>
    <span id="resCommandFileConfigure">${res.EventActionsCommandFileConfigure}</span>
    <span id="resCommandFileEdit">${res.EventActionsCommandFileEdit}</span>
  </div>

</body>
</html>