<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="${localeData.resourcesLocale}">
  <c:set var="res" value="${localeData.properties}" />
  <c:set var="version" value="?${pcbeSettings.productVersion}"/>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="Expires" content="-1">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
    <link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
    <link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
    <link type="text/css" rel="stylesheet" href="/styles/preferences.min.css${version}">
    <c:if test="${wizard}"><link type="text/css" rel="stylesheet" href="/styles/shutdownwizard.min.css${version}"></c:if>
    <script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
    <script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
    <script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
    <script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
    <script type="text/javascript" src="/js/common.js${version}"></script>
    <script type="text/javascript" src="/js/preferences.js${version}"></script>
    <c:if test="${wizard}"><script type="text/javascript" src="/js/shutdownwizard.js${version}"></script></c:if>
    <title>${page.title}</title>
  </head>
  <body>
    <%@ include file="banner.jspf" %>
    <%@ include file="menu.jspf" %>
    <%@ include file="shutdownwizardmenu.jspf"%>
    <main id="contentcontainer">
      <h1 id="pageHeader">${page.header}</h1>
      <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
        <div id="mainbox">
          <h2 id="ceipHeader">${res['CEIP.Header']}</h2>
          <div class="label-value-group ui-corner-all">
            <div class="label-value-pair">
              <div class="valueEntry">${res['CEIP.Intro1']}</div>
            </div>
            <div class="label-value-pair">
              <div class="valueEntry">${res['CEIP.Intro2']}</div>
            </div>
            <div class="label-value-pair">
              <div class="valueEntry">${res['CEIP.Intro3']}</div>
            </div>
            <div class="label-value-pair">
              <label class="emphasis autowidth" for="enableCEIPCheckBox">${res['CEIP.EnableCEIP']}</label>
              <div class="valueEntry">
                <input type="checkbox"
                       id="enableCEIPCheckBox"
                       name="enableCEIPCheckBox"
                       <c:if test="${isCEIPEnabled}">checked="checked"</c:if>
                       class="checkbox ui-corner-all jquerycheckbox editable"
                       value="" />
              </div>
            </div>
          </div>
          <c:if test="${displayAutoUpdate}">
            <h2 id="autoUpdateHeader">${res['AutoUpdate.Header']}</h2>
            <div class="label-value-group ui-corner-all">
              <div class="label-value-pair">
                <div class="valueEntry">${res['AutoUpdate.Intro1']}</div>
              </div>
              <div class="label-value-pair">
                <div class="valueEntry">${res['AutoUpdate.Intro2']}</div>
              </div>
              <div class="label-value-pair">
                <label class="emphasis autowidth" for="enableAutoUpdateCheckBox">${res['AutoUpdate.EnableAutoUpdate']}</label>
                <div class="valueEntry">
                  <input type="checkbox"
                         id="enableAutoUpdateCheckBox"
                         name="enableAutoUpdateCheckBox"
                         <c:if test="${isAutoUpdateEnabled}">checked="checked"</c:if>
                         class="checkbox ui-corner-all jquerycheckbox editable"
                         value="" />
                </div>
              </div>
            </div>
          </c:if>
          <%@ include file="button.jspf"%>
          <%@ include file="shutdownwizardbutton.jspf"%>
        </div>
        <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}"/>
        <input type="hidden" name="formtokenid" id="formtokenid" value="${formtokenid}"/>
      </form>
      <div id="submitdialog" title="${res.SubmitDialogTitle}">
        <p>${res.SubmitDialogContent}</p>
        <p class="waitimg"><img src="/styles/images/wait.gif${version}" /></p>
      </div>
    </main>

    <div class="hidden">
      <span id="isCEIPConfigured">${isCEIPConfigured}</span>
    </div>
  </body>
</html>