<!DOCTYPE html>
<%@ page trimDirectiveWhitespaces="true"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="pcssfn" uri="PCSSFunctions"%>
<html lang="${localeData.resourcesLocale}">
<c:set var="res" value="${localeData.properties}" />
<c:set var="version" value="?${pcbeSettings.productVersion}" />
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Expires" content="-1">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">
<link type="text/css" rel="stylesheet" href="/styles/jquery.cluetip.min.css${version}">
<link type="text/css" rel="stylesheet" href="/styles/cupertino/jquery-ui-1.8.14.custom.min.css">
<link type="text/css" rel="stylesheet" href="/styles/pcbe-jquery-ui-overrides.min.css${version}">
<link type="text/css" rel="stylesheet" href="/styles/common.min.css${version}">
<link type="text/css" rel="stylesheet" href="/styles/shutdownsettings.min.css${version}">
<c:if test="${wizard}">
  <link type="text/css" rel="stylesheet" href="/styles/shutdownwizard.min.css${version}">
</c:if>
<script type="text/javascript" src="/js/jquery-1.5.2.min.js"></script>
<script type="text/javascript" src="/js/jquery.cluetip.js${version}"></script>
<script type="text/javascript" src="/js/jquery.validate.min.js${version}"></script>
<script type="text/javascript" src="/js/jquery-ui-1.8.14.custom.min.js"></script>
<script type="text/javascript" src="/js/common.js${version}"></script>
<script type="text/javascript" src="/js/shutdownsettings.js${version}"></script>
<c:forEach var="jssrc" items="${page.scriptSource}">
  <script type="text/javascript" src="${jssrc}${version}"></script>
</c:forEach>
<c:if test="${wizard}">
  <script type="text/javascript" src="/js/shutdownwizard.js${version}"></script>
</c:if>
<title>${page.title}</title>
</head>
<body>
  <%@ include file="banner.jspf"%>
  <%@ include file="menu.jspf"%>
  <%@ include file="shutdownwizardmenu.jspf"%>
  <main id="contentcontainer">
    <h1 id="pageHeader">${page.header}</h1>

    <c:if test="${isSimpleSignaling eq true}">
      <div id="simplesignalingwarning" class="ui-corner-all">
        <span class="warningimg"></span>${res['SimpleSignalingMsg']}
      </div>
    </c:if>

    <div id="errorcontainer" class="ui-corner-all">${res['ErrorBoxMsg']}</div>

    <form id="formpageform" action="<c:url value='${page.action}'/>" name="${page.name}" method="post">
      <div id="mainbox">
        <c:set var="target_outlet_groups" value="${outletSystem.targetOutletGroups}" />
        <c:set var="pcbe_outlet_group" value="${outletSystem.PCBEOutletGroup}" />
        <c:set var="pcbe_outlet_group_name"
          value="${not empty pcbe_outlet_group.outletName ? pcbe_outlet_group.outletName : pcbe_outlet_group.outletLabel}" />

        <%-- If Back-UPS has fixed turnoff delay then we don't display it--%>
        <c:set var="isBackUPSTurnOffDelayReadOnly" value="${isBackUPS && turnOffDelayData.readOnly}" />

        <%-- Power Failure Configuration section --%>
        <h2 class="expandable" id="powerFailConfigurationSubHeader">${res['PowerFailConfigurationSubHeader']}</h2>
        <div id="conditions" class="label-value-group ui-corner-all">

          <div class="label-value-pair">
            <label class="labelauto">${res['ShutdownSettings.ConditionsTitle']}</label>
          </div>

          <%-- 'Immediately' radio button --%>
          <div class="label-value-pair">
            <input type="radio" name="value_shutdownSettingsRadioButtonGroup" id="new_value_Immediately"
              title="${res['ShutdownSettings.TooltipImmediately']}" class="radio inputcheck"
              value="${ShutdownImmediately}" />
            <%-- Passed in as request attribute --%>
            <label for="new_value_Immediately" title="${res['ShutdownSettings.TooltipImmediately']}">${res['ShutdownSettings.Immediately']}</label>
          </div>

          <%-- 'After UPS has been on battery for' radio button--%>
          <c:if test="${batterySystem.timeOnBatteryThresholdSupported}">
            <div class="label-value-pair">
              <input type="radio" name="value_shutdownSettingsRadioButtonGroup" id="new_value_TimeOnBatteryThreshold"
                title="${res['ShutdownSettings.TooltipOnBatteryThreshold']}" class="radio inputcheck"
                value="${ShutdownAfterTimeOnBattery}" />
              <%-- Passed in as request attribute --%>
              <label for="new_value_TimeOnBatteryThreshold" title="${res['ShutdownSettings.TooltipOnBatteryThreshold']}">${res['ShutdownSettings.OnBatteryThreshold']}</label>
              <div class="valueEntry">
                <input type="text" value="${batterySystem.timeOnBatteryThreshold}" name="value_TimeOnBatteryThreshold"
                  class="textinput ui-corner-all configsecs required posint editable"
                  min="${batterySystem.timeOnBatteryThresholdMin}" max="${batterySystem.timeOnBatteryThresholdMax}"
                  id="value_TimeOnBatteryThreshold" maxlength="4" />
                <%-- could make this dynamic in future versions - like min and max values --%>
                <div class="unit">${res.SeondsLabelShort}</div>
              </div>
            </div>
          </c:if>

          <%-- 'At runtime limit' radio button--%>
          <c:if test="${batterySystem.lowRuntimeWarningSettingSupported}">
            <div class="label-value-pair">
              <input type="radio" name="value_shutdownSettingsRadioButtonGroup" id="new_value_LowRuntimeThreshold"
                title="${res['ShutdownSettings.TooltipRuntimeLimit']}" class="radio inputcheck"
                value="${ShutdownAtRuntimeLimit}" />
              <%-- Passed in as request attribute --%>
              <c:if test="${isSimpleSignaling eq true}">
                <label for="new_value_LowRuntimeThreshold" title="${res['ShutdownSettings.TooltipRuntimeLimit']}">${res['ShutdownSettings.RuntimeLimitSimpleSignaling']}</label>
              </c:if>
              <c:if test="${isSimpleSignaling eq false}">
                <label for="new_value_LowRuntimeThreshold" title="${res['ShutdownSettings.TooltipRuntimeLimit']}">${res['ShutdownSettings.RuntimeLimit']}</label>
              </c:if>
              <div class="valueEntry">

                <c:if test="${isSimpleSignaling eq false}">
                  <c:if test="${isUPSLinkSerialOrMedium}">
                    <c:if test="${empty runtimeLimitData}">${res.ValueNotFound}</c:if>
                    <c:if test="${!empty runtimeLimitData}">
                      <select id="value_LowRuntimeThreshold" name="value_LowRuntimeThreshold" size="1"
                        class="dropdown ui-corner-all editable">
                        <c:forEach var="runLimit" items="${runtimeLimitData}">
                          <c:choose>
                            <c:when test="${runLimit == runtimeLimitSelectedData}">
                              <option selected="selected" value="${runLimit}">${runLimit}</option>
                            </c:when>
                            <c:otherwise>
                              <option value="${runLimit}">${runLimit}</option>
                            </c:otherwise>
                          </c:choose>
                        </c:forEach>
                      </select>
                      <div class="unit">${res.SeondsLabelShort}</div>
                    </c:if>
                  </c:if>

                  <c:if test="${!isUPSLinkSerialOrMedium}">
                    <input type="text" value="${batterySystem.lowRuntimeWarningSetting}"
                      name="value_LowRuntimeThreshold"
                      class="textinput ui-corner-all configsecs required posint editable"
                      min="${batterySystem.lowRuntimeWarningSettingMin}"
                      max="${batterySystem.lowRuntimeWarningSettingMax}" id="value_LowRuntimeThreshold" maxlength="4" />
                    <%-- could make this dynamic in future versions - like min and max values --%>
                    <div class="unit">${res.SeondsLabelShort}</div>
                  </c:if>

                </c:if>

              </div>
            </div>
          </c:if>

          <%-- 'No Shutdown' radio button --%>
          <div class="label-value-pair">
            <input type="radio" name="value_shutdownSettingsRadioButtonGroup" id="new_value_NoShutdown"
              title="${res['ShutdownSettings.TooltipNoShutdown']}" class="radio inputcheck" value="${ShutdownNever}" />
            <%-- Passed in as request attribute --%>
            <label for="new_value_NoShutdown" title="${res['ShutdownSettings.TooltipNoShutdown']}">${res['ShutdownSettings.NoShutdown']}</label>
          </div>
        </div>
        <%-- id="conditions" --%>

        <%-- Shutdown Delays section --%>
        <c:set var="sog" value="${outletSystem.PCBEOutletGroup }" />
        <h2 class="expandable" id="shutdownDelaysSubHeader">${res['ShutdownDelaysSubHeader']}</h2>
        <div class="label-value-group ui-corner-all">

          <c:if test="${isBackUPS}">
            <c:set var="shutdown_type" value="${osShutdown.OSShutdownType}"/>
            <c:set var="hibernate_supported" value="${osShutdown.OSHibernationSupported}"/>
            <div id="shutdowntype_selectbox" class="label-value-pair">
              <label for="shutdowntype_select">${res['ShutdownSettings.OSShutdownType']}</label>
              <div class="valueEntry">
                <select id="shutdowntype_select" name="shutdowntype_select" size="1" class="dropdown ui-corner-all editable">
                  <option value="0"
                    <c:if test="${shutdown_type == 0}">selected="selected"</c:if>>
                    <c:out value="${res['ShutdownSettings.OSShutdownTypeShutdown']}"/>
                  </option>
                  <option value="1"
                    <c:if test="${shutdown_type == 1}">selected="selected"</c:if>
                    <c:if test="${not hibernate_supported}">disabled="disabled" title="${res['ShutdownSettings.HibernateNotSupported']}"</c:if>>
                    <c:out value="${res['ShutdownSettings.OSShutdownTypeHibernate']}"/>
                  </option>
                </select>
              </div>
            </div>
          </c:if>

          <c:if test="${isBackUPS}">
            <c:set var="shutdown_ups_enabled" value="${osShutdown.shutdownUPSEnabled}"/>
            <div id="shutdownUPSBox" class="label-value-pair">
              <label for="enableShutdownUPSCheckBox">${res['ShutdownSettings.ShutdownUPS']}</label>
              <div class="valueEntry">
                <input type="checkbox"
                      id="enableShutdownUPSCheckBox"
                      name="enableShutdownUPSCheckBox"
                      <c:if test="${shutdown_ups_enabled}">checked="checked"</c:if>
                      class="checkbox ui-corner-all jquerycheckbox editable"
                      value=""/>
              </div>
            </div>
          </c:if>

          <c:if test="${not isSimpleSignaling && not isBackUPSTurnOffDelayReadOnly}">
            <div id="turnOffDelayBox" class="label-value-pair">
              <label for="turnoffdelay">${res['ShutdownSettings.TurnOffDelayShutdown']}</label>
              <div class="valueEntry">
                <c:choose>
                  <c:when test="${isUPSLink || isBackUPS}">
                    <select id="turnoffdelay" name="turnOffCountdownSetting" size="1"
                    <c:if test="${turnOffDelayData.readOnly}">disabled="disabled"</c:if> 
                    class="dropdown ui-corner-all configsecs editable">
                      <c:forEach var="selectOption" items="${turnOffDelayData.optionList}" varStatus="option">
                        <option value="${selectOption.value}"
                        <c:if test="${turnOffDelayData.selectedIndex == option.index}">selected="selected"</c:if>>
                          <c:out value="${selectOption.displayValue}" />
                        </option>
                      </c:forEach>
                    </select>
                  </c:when>
                  <c:otherwise>
                    <input type="text" value="${osShutdown.OSShutdownDuration}" name="turnOffCountdownSetting"
                    class="textinput ui-corner-all turnOff delay configsecs required posint editable"
                    min="${sog.minTurnOffCountdownSetting}" max="${sog.maxTurnOffCountdownSetting}" id="turnoffdelay"
                    maxlength="4" />
                  </c:otherwise>
                </c:choose>
                <div class="unit">${res.SeondsLabelShort}</div>
              </div>
            </div>
          </c:if>

          <div class="label-value-pair">
            <label class="labelauto"><c:out value="${res['ShutdownSettings.CommandFileInfo']}" /></label>
          </div>
          <div id="cmdfile_selectbox" class="label-value-pair">
            <label for="cmdfile_select">${res.EventActionsCmdFileChoose}</label>
            <div class="valueEntry" title="|${cmdFilesDir}">
              <select id="cmdfile_select" name="cmdfile_select" size="1" class="dropdown ui-corner-all editable">
                <c:forEach items="${cmdFilesListMap}" var="cmdFile">
                  <c:set var="theValue" value="${cmdFile.key == 'NONE' ? cmdFile.value : cmdFile.key }" />
                  <c:choose>
                    <c:when test="${cmdFile.key == cmdFileSelected}">
                      <option selected="selected" value="${cmdFile.key}">${theValue}</option>
                    </c:when>
                    <c:otherwise>
                      <option value="${cmdFile.key}">${theValue}</option>
                    </c:otherwise>
                  </c:choose>
                </c:forEach>
              </select>
            </div>
            <input type="button" id="button_test" class="button" value="${res.ButtonTest}" name="button_test" />
          </div>
          <div id="shutdowndelaybox" class="label-value-pair">
            <label for="shutdowndelay"><c:out value="${res['ShutdownSettings.CommandFileDuration']}" /></label>
            <div class="valueEntry">
              <input type="text" value="${osShutdown.shutdownEventCmdFileDuration}" name="osShutdownDelay"
                class="textinput ui-corner-all shutdown configsecs required posint editable"
                min="${osShutdown.minOSShutdownDelay}" max="${osShutdown.maxOSShutdownDelay}" id="shutdowndelay"
                maxlength="5" />
              <%-- could make this dynamic in future versions - like min and max values --%>
              <div class="unit">${res.SeondsLabelShort}</div>
            </div>
          </div>

        </div>

        <c:if test="${not isSimpleSignaling}">

          <%-- Shutdown Summary section --%>
          <h2 class="expandable" id="shutdownSummarySubHeader">${res['ShutdownSummarySubHeader']}</h2>
          <div id="shutdownsummary">
            <div class="label-value-group">
              <div class="shutdownhead">
                <c:out value="${res['ShutdownSettings.SummaryFirstLine']}" />
              </div>
              <div id="Immediately_text" class="shutdowntext">
                <c:out value="${res['ShutdownSettings.SummaryImmediately']}" />
              </div>
              <div id="TimeOnBatteryThreshold_text" class="shutdowntext">
                ${pcssfn:format1(res['ShutdownSettings.SummaryTimeOnBattery'], "<span id='summary_time_on_battery'></span>" )}
              </div>
              <div id="LowRuntimeThreshold_text" class="shutdowntext">
                ${pcssfn:format1(res['ShutdownSettings.SummaryRuntimeLimit'], "<span id='summary_runtime_limit'></span>" )}
              </div>
              <div id="NoShutdown_text" class="shutdowntext">
                <c:out value="${res['ShutdownSettings.SummaryNoShutdown']}" />
              </div>
              <div id="summarypowerfails" class="summarybox ui-corner-all">
                <table class="summarytable">
                  <thead>
                    <tr>
                      <th>${res['ShutdownSettings.SummaryTimeHeader']}</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr id="cmd_file_row">
                      <td id="cmd_file_start" class="timecolumn"></td>
                      <td class="timelabelcolumn">${res.SeondsLabelShort}</td>
                      <td class="summarycolumn">${res['ShutdownSettings.SummaryCmdFileStarts']}</td>
                    </tr>
                    <tr>
                      <td id="os_sd_start" class="timecolumn"></td>
                      <td class="timelabelcolumn">${res.SeondsLabelShort}</td>
                      <td class="summarycolumn">${res['ShutdownSettings.SummaryOSShutdownStarts']}</td>
                    </tr>
                    <c:if test="${not isBackUPSTurnOffDelayReadOnly}">
                      <tr id="og_turn_off_row">
                        <td id="og_turn_off" class="timecolumn"></td>
                        <td class="timelabelcolumn">${res.SeondsLabelShort}</td>
                        <td class="summarycolumn">${pcssfn:format1(res['ShutdownSettings.SummaryPCBEOutletTurnOff'], pcbe_outlet_group_name)}
                          <c:if test="${not empty targetOutletNames}">
                            <br />${pcssfn:format1(res['ShutdownSettings.SummaryOutletGroupsTurnOff'], targetOutletNames)}
                          </c:if>
                        </td>
                      </tr>
                    </c:if>
                  </tbody>
                </table>
              </div>
            </div>
            
            <c:if test="${not isBackUPS}">
              <div id="summarypowerreturns" class="label-value-group">
                <div class="shutdownhead">
                  <c:out value="${res['ShutdownSettings.SummaryPowerReturns']}" />
                </div>
                <div class="summarybox ui-corner-all">
                  <table class="summarytable">
                    <c:if test="${not outletSystem.manualTurnOn}">
                      <thead>
                        <tr>
                          <th>${res['ShutdownSettings.SummaryTimeHeader']}</th>
                        </tr>
                      </thead>
                    </c:if>
                    <tbody>
                      <tr>
                        <c:choose>
                          <c:when test="${outletSystem.manualTurnOn}">
                            <td class="timecolumn"></td>
                            <td class="timelabelcolumn"></td>
                            <td class="summarycolumn">
                              ${pcssfn:format1(res['ShutdownSettings.SummaryPCBEOutletStayOff'], pcbe_outlet_group_name)}
                              <c:if test="${not empty targetOutletNames}">
                                <br />${pcssfn:format1(res['ShutdownSettings.SummaryOutletGroupsStayOff'], targetOutletNames)}
                              </c:if>
                            </td>
                          </c:when>
                          <c:otherwise>
                            <td id="og_turn_on" class="timecolumn"></td>
                            <td class="timelabelcolumn">${res.SeondsLabelShort}</td>
                            <td class="summarycolumn">
                              ${pcssfn:format1(res['ShutdownSettings.SummaryPCBEOutletTurnOn'], pcbe_outlet_group_name)} 
                              <c:if test="${not empty targetOutletNames}">
                                <br />${pcssfn:format1(res['ShutdownSettings.SummaryOutletGroupsTurnOn'], targetOutletNames)}
                              </c:if>
                            </td>
                          </c:otherwise>
                        </c:choose>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </c:if> <%-- not isBackUPS --%>

            <c:if test="${not isBackUPSTurnOffDelayReadOnly}">
              <div class="label-value-group">
                <%-- Insufficient runtime note --%>
                <div id="insufficientruntimetext" class="ui-corner-all">
                    ${pcssfn:format1(res['ShutdownSettings.RuntimeRemainingNote'], "<span id='total_shutdown_time'></span>")}
                </div>
  
                <%-- Show Load Shed Warning if needed --%>
                <c:if test="${not empty loadShedEnabled}">
                  <div id="loadshedtext" class="ui-corner-all warningbox">
                    <span class="warningimg"></span>${res['ShutdownSettings.SummaryLoadShedEnabled']}
                  </div>
                </c:if>
              </div>
            </div>
          </c:if>

        </c:if> <%-- not isSimpleSignaling --%>

        <div id="alertMessageDialog" class="dialog"></div>

        <c:forEach var="hidden" items="${page.hiddenInputs}">
          <input type="hidden" id="${hidden.id}" name="${hidden.name}" value="<c:out value="${hidden.value}"/>"
            <c:if test="${not empty hidden.cssClasses}"> class="${hidden.cssClassesAsString}"</c:if> />
        </c:forEach>

        <%@ include file="button.jspf"%>
        <%@ include file="shutdownwizardbutton.jspf"%>
      </div>
      <input type="hidden" name="formtoken" id="formtoken" value="${formtoken}" /> <input type="hidden"
        name="formtokenid" id="formtokenid" value="${formtokenid}" />
    </form>

    <div id="submitdialog" title="${res.SubmitDialogTitle}">
      <p>${res.SubmitDialogContent}</p>
      <p class="waitimg">
        <img src="/styles/images/wait.gif${version}" />
      </p>
    </div>
  </main>
  <%-- contentcontainer --%>

  <div class="hidden">
    <span id="lowBatteryCmdDuration">${lowBatteryCmdDuration}</span> <span id="timeOnBatteryCmdDuration">${timeOnBatteryCmdDuration}</span>
    <span id="powerFailureCmdDuration">${powerFailureCmdDuration}</span> <span id="maxCmdDuration">${maxCmdDuration}</span>
    <span id="SimpleSignalingMsgURL">${SimpleSignalingMsgURL}</span> <span id="ajaxCmdFileTestURL"><c:url
        value="/ajaxsdcmdfiletest" /></span>
  </div>
  <div id="res">
    <span id="resSeondsLabelShort">${res.aSeondsLabelShort}</span> <span id="resNotANumberError">${res.NotANumberError}</span>
    <span id="resNavigateAwayMsg">${res.NavigateAwayMsg}</span> <span id="resButtonOK">${res.ButtonOK}</span> <span
      id="resYes">${res.Yes}</span> <span id="resNo">${res.No}</span> <span id="resCmdFileTestConfirmTitle">${res.CmdFileTestConfirmTitle}</span>
    <span id="resCmdFileTestConfirmMessage">${res.CmdFileTestConfirmMessage}</span> <span id="resCmdFileTestTitle">${res.CmdFileTestTitle}</span>
    <span id="resCmdFileTestSuccess">${res.CmdFileTestSuccess}</span> <span id="resCmdFileTestFail">${res.CmdFileTestFail}</span>
    <span id="resValueNotFound">${res.ValueNotFound}</span>
    <c:if test="${schedules}">
      <span id="resChangeDelaysScheduleWarningTitle">${res.ChangeDelaysScheduleWarningTitle}</span>
    </c:if>
    <c:if test="${schedules}">
      <span id="resChangeDelaysScheduleWarningMessage">${res.ChangeDelaysScheduleWarningMessage}</span>
    </c:if>
  </div>
</body>
</html>